bool messageMode = true; // upewnij się, że serwer i klient ustawiają to samo

if (messageMode)
{
	using var s = new NamedPipeServerStream ("pipedream", PipeDirection.InOut,
                                              1, PipeTransmissionMode.Message);

	s.WaitForConnection();

	byte[] msg = Encoding.UTF8.GetBytes ("Hello");
	s.Write (msg, 0, msg.Length);

	Console.WriteLine (Encoding.UTF8.GetString (ReadMessage (s)));
}
else
{
	using var s = new NamedPipeServerStream ("pipedream");

	Console.WriteLine ("Uruchom nazwanego klienta potoku.");
	s.WaitForConnection();
	s.WriteByte (100);                // wyślij wartość 100
	Console.WriteLine ("Odpowiedź od nazwanego klienta potoku.");
	Console.WriteLine (s.ReadByte());
}

static byte[] ReadMessage (PipeStream s)
{
	MemoryStream ms = new MemoryStream();
	byte[] buffer = new byte [0x1000];      // wczytuje bloki 4 KB

	do { ms.Write (buffer, 0, s.Read (buffer, 0, buffer.Length)); }
	while (!s.IsMessageComplete);

	return ms.ToArray();
}